{********************************************
; File: Windows.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT WINDOWS;
INTERFACE
USES TYPES,QUICKDRAW,EVENTS,CONTROLS;
CONST


{ Error Codes }
paramLenErr = $0E01;  { first word of parameter list is the wrong size }
allocateErr = $0E02;  { unable to allocate window record }
taskMaskErr = $0E03;  { bits 12-15 are not clear in WmTaskMask field of EventRecord }

{ Axis Parameters }
wNoConstraint = $0000;  { No constraint on movement. }
wHAxisOnly = $0001;  { Horizontal axis only. }
wVAxisOnly = $0002;  { Vertical axis only. }

{ Desktop Command Codes }
FromDesk = $00;  { Subtract region from desktop }
ToDesk = $1;  { Add region to desktop }
GetDesktop = $2;  { Get Handle of Desktop region }
SetDesktop = $3;  { Set Handle of Desktop region }
GetDeskPat = $4;  { Address of  pattern or drawing routine }
SetDeskPat = $5;  { Change Address of  pattern or drawing routine }
GetVisDesktop = $6;  { Get destop region less visible windows. }
BackGroundRgn = $7;  { For drawing directly on desktop. }

{ SendBehind Values }
toBottom = $FFFFFFFE;  { To send window to bottom. }
topMost = $FFFFFFFF;  { To make window top. }
bottomMost = $0000;  { To make window bottom. }

{ Task Masks }
tmMenuKey = $00000001;
tmUpdate = $00000002;
tmFindW = $00000004;
tmMenuSel = $0008;
tmOpenNDA = $0010;
tmSysClick = $0020;
tmDragW = $0040;
tmContent = $0080;
tmClose = $0100;
tmZoom = $0200;
tmGrow = $0400;
tmScroll = $0800;
tmSpecial = $1000;
tmCRedraw = $2000;
tmInactive = $4000;
tmInfo = $8000;
tmContentControls = $00010000;
tmControlKey = $00020000;
tmControlMenu = $00040000;
tmMultiClick = $00080000;
tmIdleEvents = $00100000;

{ TaskMaster Codes }
wNoHit = $0000;  { retained for back compatibility.  }
inNull = $0000;  { retained for back compatibility }
inKey = $0003;  { retained for back compatibility }
inButtDwn = $0001;  { retained for back compatibility }
inUpdate = $0006;  { retained for back compatibility }
wInDesk = $0010;  { On Desktop }
wInMenuBar = $0011;  { On system menu bar }
wClickCalled = $0012;  { system click called }
wInContent = $0013;  { In content region }
wInDrag = $0014;  { In drag region }
wInGrow = $0015;  { In grow region, active window only }
wInGoAway = $0016;  { In go-away region, active window only }
wInZoom = $0017;  { In zoom region, active window only }
wInInfo = $0018;  { In information bar }
wInSpecial = $0019;  { Item ID selected was 250 - 255 }
wInDeskItem = $001A;  { Item ID selected was 1 - 249 }
wInFrame = $1B;  { in Frame, but not on anything else }
wInactMenu = $1C;  { 'selection' of inactive menu item }
wClosedNDA = $001D;  { desk accessory closed }
wCalledSysEdit = $001E;  { inactive menu item selected }
wInSysWindow = $8000;  { hi bit set for system windows }

{ VarCode }
wDraw = $00;  { Draw window frame command. }
wHit = $01;  { Hit test command. }
wCalcRgns = $02;  { Compute regions command. }
wNew = $03;  { Initialization command. }
wDispose = $04;  { Dispose command. }

{ WFrame }
fHilited = $0001;  { Window is highlighted. }
fZoomed = $0002;  { Window is zoomed. }
fAllocated = $0004;  { Window record was allocated. }
fCtlTie = $0008;  { Window state tied to controls. }
fInfo = $0010;  { Window has an information bar. }
fVis = $0020;  { Window is visible. }
fQContent = $0040;
fMove = $0080;  { Window is movable. }
fZoom = $0100;  { Window is zoomable. }
fFlex = $0200;
fGrow = $0400;  { Window has grow box. }
fBScroll = $0800;  { Window has horizontal scroll bar. }
fRScroll = $1000;  { Window has vertical scroll bar. }
fAlert = $2000;
fClose = $4000;  { Window has a close box. }
fTitle = $8000;  { Window has a title bar. }

{ Other Constants }
windSize = $00D4;  { Size of WindRec. }
wmTaskRecSize = $002E;  { Size of WmTaskRec. }
wTrackZoom = $001F;
wHitFrame = $0020;
wInControl = $0021;
wInControlMenu = $0022;

TYPE
WmTaskRec = EventRecord ;


WmTaskRecPtr = EventRecordPtr ;

WindColorHndl = ^WindColorPtr;
WindColorPtr = ^WindColor;
WindColor = RECORD
    frameColor : Integer; { Color of window frame. }
    titleColor : Integer; { Color of title and bar. }
    tBarColor : Integer; { Color/pattern of title bar. }
    growColor : Integer; { Color of grow box. }
    infoColor : Integer; { Color of information bar. }
END;
WindRecPtr = ^WindRec;
WindRec = RECORD
    wNext : WindRecPtr;
    port : GrafPort; { Window's port }
    wDefProc : ProcPtr;
    wRefCon : Longint;
    wContDraw : ProcPtr;
    wReserved : Longint; { Space for future expansion }
    wStrucRgn : RegionHndl; { Region of frame plus content. }
    wContRgn : RegionHndl; { Content region. }
    wUpdateRgn : RegionHndl; { Update region. }
    wControls : CtlRecHndl; { Window's control list. }
    wFrameCtrls : CtlRecHndl; { Window frame's control list. }
    wFrame : Integer;
END;
ParamListHndl = ^ParamListPtr;
ParamListPtr = ^ParamList;
ParamList = RECORD
    paramLength : Integer; { Parameter to NewWindow.  }
    wFrameBits : Integer; { Parameter to NewWindow. }
    wTitle : Ptr; { Parameter to NewWindow. }
    wRefCon : Longint; { Parameter to NewWindow. }
    wZoom : Rect; { Parameter to NewWindow. }
    wColor : WindColorPtr; { Parameter to NewWindow. }
    wYOrigin : Integer; { Parameter to NewWindow. }
    wXOrigin : Integer; { Parameter to NewWindow. }
    wDataH : Integer; { Parameter to NewWindow. }
    wDataW : Integer; { Parameter to NewWindow. }
    wMaxH : Integer; { Parameter to NewWindow. }
    wMaxW : Integer; { Parameter to NewWindow. }
    wScrollVer : Integer; { Parameter to NewWindow. }
    wScrollHor : Integer; { Parameter to NewWindow. }
    wPageVer : Integer; { Parameter to NewWindow. }
    wPageHor : Integer; { Parameter to NewWindow. }
    wInfoRefCon : Longint; { Parameter to NewWindow. }
    wInfoHeight : Integer; { height of information bar }
    wFrameDefProc : LongProcPtr; { Parameter to NewWindow. }
    wInfoDefProc : VoidProcPtr; { Parameter to NewWindow. }
    wContDefProc : VoidProcPtr; { Parameter to NewWindow. }
    wPosition : Rect; { Parameter to NewWindow. }
    wPlane : WindowPtr; { Parameter to NewWindow. }
    wStorage : WindRecPtr; { Parameter to NewWindow. }
END;
DeskMessageRecordPtr = ^DeskMessageRecord;
DeskMessageRecord = RECORD
    reserved : Longint;
    messageType : Integer;
    drawType : Integer;
END;

FUNCTION AlertWindow ( alertFlags:Integer; subStrPtr:Ptr; alertStrRef:Ref) : Integer ;
PROCEDURE BeginUpdate ( theWindowPtr:WindowPtr)  ;
PROCEDURE BringToFront ( theWindowPtr:WindowPtr)  ;
FUNCTION CheckUpdate ( theEventPtr:EventRecordPtr) : Boolean ;
PROCEDURE CloseWindow ( theWindowPtr:WindowPtr)  ;
FUNCTION CompileText ( subType:Integer; subStringsPtr:Ptr; srcStringPtr:Ptr; srcSize:Integer) : Handle ;
FUNCTION Desktop ( deskTopOP:Integer; dtParam:Longint) : Ptr ;
PROCEDURE DragWindow ( grid:Integer; startX:Integer; startY:Integer; grace:Integer; boundsRectPtr:RectPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE DrawInfoBar ( theWindowPtr:WindowPtr)  ;
PROCEDURE EndFrameDrawing   ;
PROCEDURE EndInfoDrawing   ;
PROCEDURE EndUpdate ( theWindowPtr:WindowPtr)  ;
FUNCTION ErrorWindow ( subType:Integer; subStringPtr:Ptr; errNum:Integer) : Integer ;
FUNCTION FindWindow (VAR theWindowPtr:WindowPtr; pointX:Integer; pointY:Integer) : Integer ;
FUNCTION FrontWindow  : WindowPtr ;
PROCEDURE GDRPrivate   ;
FUNCTION GetContentDraw ( theWindowPtr:WindowPtr) : VoidProcPtr ;
FUNCTION GetContentOrigin ( theWindowPtr:WindowPtr) : Point ;
FUNCTION  GetContentRgn ( theWindowPtr:WindowPtr) : RegionHndl ;
FUNCTION GetDataSize ( theWindowPtr:WindowPtr) : Longint ;
FUNCTION GetDefProc ( theWindowPtr:WindowPtr) : LongProcPtr ;
FUNCTION GetFirstWindow  : WindowPtr ;
PROCEDURE GetFrameColor (VAR colorPtr:WindColor; theWindowPtr:WindowPtr)  ;
FUNCTION GetInfoDraw ( theWindowPtr:WindowPtr) : VoidProcPtr ;
FUNCTION GetInfoRefCon ( theWindowPtr:WindowPtr) : Longint ;
FUNCTION GetMaxGrow ( theWindowPtr:WindowPtr) : Longint ;
FUNCTION GetNextWindow ( theWindowPtr:WindowPtr) : WindowPtr ;
FUNCTION GetPage ( theWindowPtr:WindowPtr) : Longint ;
PROCEDURE GetRectInfo (VAR infoRectPtr:Rect; theWindowPtr:WindowPtr)  ;
FUNCTION GetScroll ( theWindowPtr:WindowPtr) : Longint ;
FUNCTION  GetStructRgn ( theWindowPtr:WindowPtr) : RegionHndl ;
FUNCTION GetSysWFlag ( theWindowPtr:WindowPtr) : Boolean ;
FUNCTION  GetUpdateRgn ( theWindowPtr:WindowPtr) : RegionHndl ;
FUNCTION GetWControls ( theWindowPtr:WindowPtr) : CtlRecHndl ;
FUNCTION GetWFrame ( theWindowPtr:WindowPtr) : Integer ;
FUNCTION GetWKind ( theWindowPtr:WindowPtr) : Integer ;
FUNCTION GetWMgrPort  : WindowPtr ;
FUNCTION GetWRefCon ( theWindowPtr:WindowPtr) : Longint ;
FUNCTION GetWTitle ( theWindowPtr:WindowPtr) : Ptr ;
FUNCTION GetWindowMgrGlobals  : Ptr ;
FUNCTION GetZoomRect ( theWindowPtr:WindowPtr) : RectPtr ;
FUNCTION GrowWindow ( minWidth:Integer; minHeight:Integer; startX:Integer; startY:Integer; theWindowPtr:WindowPtr) : Longint ;
PROCEDURE HideWindow ( theWindowPtr:WindowPtr)  ;
PROCEDURE HiliteWindow ( fHiliteFlag:Boolean; theWindowPtr:WindowPtr)  ;
PROCEDURE InvalRect ( badRectPtr:Rect)  ;
PROCEDURE InvalRgn ( badRgnHandle:RegionHndl)  ;
PROCEDURE MoveWindow ( newX:Integer; newY:Integer; theWindowPtr:WindowPtr)  ;
FUNCTION NewWindow ( theParamListPtr:ParamList) : WindowPtr ;
FUNCTION NewWindow2 ( titlePtr:StringPtr; refCon:Longint; contentDrawPtr:ProcPtr; defProcPtr:ProcPtr; paramTableDesc:RefDescriptor; paramTableRef:Ref; resourceType:Integer) : WindowPtr ;
FUNCTION PinRect ( theXPt:Integer; theYPt:Integer; theRectPtr:Rect) : Point ;
PROCEDURE RefreshDesktop ( redrawRect:RectPtr)  ;
PROCEDURE ResizeWindow ( hiddenFlag:Boolean; newRectPtr:Rect; theWindowPtr:WindowPtr)  ;
PROCEDURE SelectWindow ( theWindowPtr:WindowPtr)  ;
PROCEDURE SendBehind ( behindWindowPtr:WindowPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE SetContentDraw ( contentDrawPtr:VoidProcPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE SetContentOrigin ( xOrigin:Integer; yOrigin:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetContentOrigin2 ( scrollFlag:Integer; xOrigin:Integer; yOrigin:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetDataSize ( dataWidth:Integer; dataHeight:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetDefProc ( wDefProcPtr:LongProcPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE SetFrameColor ( newColorPtr:WindColorPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE SetInfoDraw ( infoRecCon:VoidProcPtr; theWindowPtr:WindowPtr)  ;
PROCEDURE SetInfoRefCon ( infoRefCon:Longint; theWindowPtr:WindowPtr)  ;
PROCEDURE SetMaxGrow ( maxWidth:Integer; maxHeight:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetOriginMask ( originMask:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetPage ( hPage:Integer; vPage:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetScroll ( hScroll:Integer; vScroll:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetSysWindow ( theWindowPtr:WindowPtr)  ;
PROCEDURE SetWFrame ( wFrame:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE SetWRefCon ( wRefCon:Longint; theWindowPtr:WindowPtr)  ;
PROCEDURE SetWTitle ( title:Str255; theWindowPtr:WindowPtr)  ;
FUNCTION SetWindowIcons ( newFontHandle:FontHndl) : FontHndl ;
PROCEDURE SetZoomRect ( wZoomSizePtr:Rect; theWindowPtr:WindowPtr)  ;
PROCEDURE ShowHide ( showFlag:Boolean; theWindowPtr:WindowPtr)  ;
PROCEDURE ShowWindow ( theWindowPtr:WindowPtr)  ;
PROCEDURE SizeWindow ( newWidth:Integer; newHeight:Integer; theWindowPtr:WindowPtr)  ;
PROCEDURE StartDrawing ( theWindowPtr:WindowPtr)  ;
PROCEDURE StartFrameDrawing ( theWindowPtr:WindowPtr)  ;
PROCEDURE StartInfoDrawing (VAR infoRectPtr:Rect; theWindowPtr:WindowPtr)  ;
FUNCTION TaskMaster ( taskMask:Integer; taskRecPtr:WmTaskRec) : Integer ;
PROCEDURE TaskMasterContent   ;
FUNCTION TaskMasterDA ( eventMask:Integer; taskRecPtr:WmTaskRecPtr) : Integer ;
PROCEDURE TaskMasterKey   ;
FUNCTION TrackGoAway ( startX:Integer; startY:Integer; theWindowPtr:WindowPtr) : Boolean ;
FUNCTION TrackZoom ( startX:Integer; startY:Integer; theWindowPtr:WindowPtr) : Boolean ;
PROCEDURE ValidRect ( goodRectPtr:Rect)  ;
PROCEDURE ValidRgn ( goodRgnHandle:RegionHndl)  ;
PROCEDURE WindBootInit   ;
FUNCTION WindDragRect ( actionProcPtr:VoidProcPtr; dragPatternPtr:Pattern; startX:Integer; startY:Integer; dragRectPtr:Rect; limitRectPtr:Rect; slopRectPtr:Rect; dragFlag:Integer) : Longint ;
PROCEDURE WindNewRes   ;
PROCEDURE WindReset   ;
PROCEDURE WindShutDown   ;
PROCEDURE WindStartUp ( userID:Integer)  ;
FUNCTION WindStatus  : Boolean ;
FUNCTION WindVersion  : Integer ;
FUNCTION WindowGlobal ( WindowGlobalMask:Integer) : Integer ;
PROCEDURE ZoomWindow ( theWindowPtr:WindowPtr)  ;
IMPLEMENTATION
END.
